// bergmark - telelphony project - August 1999

// Little - test new DesktopSignaling, where Directory Service is optional

//////////////////////////////////////////////////////////////////////
//     How to run this test:
//
//  Running this program as a server:    jview Little [port]
//  Running this program as a client:    jview Little <IP addr> <port>
//
//  Example:  on computer A,   jview Little
//            on computer B,   jview Little 128.84.211.242  242
//
//  Example 2: on computer A,  jview Little 5555
//             on computer B,  jview Little 128.84.211.242 5555
//
//    Details:
//
//  Little runs without a DirectoryService, and without jaudio.
//  (data channels all are null)
//
//  As a server, Little just listens for incoming invitations and
//  accepts them.  To make the server stop, type <enter>
//
//  As a client, Little does a single blocking Dial, and says
//  whether or not it got a connection.  (It should get a connection.)
//  The argument to Dial, a Location, is built out of the command-line
//  parameters.  So, start up the server first, and then run clients.
//////////////////////////////////////////////////////////////////////

//package cnrg.itx.signal;

import cnrg.itx.signal.*;  // for DesktopSignaling, Dial, etc.
import cnrg.itx.signal.SignalEvent.*;  // for InviteSignalEvent, etc.
import cnrg.itx.ds.*;      // temporary: for Location (going to cnrg.itx)
import cnrg.itx.datax.*;   // for Channel

import java.io.*;  // for halting the server

public class Little extends AbstractSignalingObserver {


   private DesktopSignaling myDS = null;
   private int peerPort = 0;
   private String peerName = "";
   private Location peerLocation = null;
   private boolean isClient = false;
   private int myPort = 0;

   public Little( String[] args ){
      if ( args.length == 1 ) // we are the server, specified port
	 myDS = new DesktopSignaling( this, 
	            Integer.valueOf(args[0]).intValue() );
      else
	 myDS = new DesktopSignaling( this );
      System.out.println ("We got a DesktopSignaling!");
      System.out.println ("We are listening on port "
      + myDS.getPort() + " on machine " + myDS.getName() );

      // If we are the client, we need to know where the server app is
      if ( args.length > 1 ) {
	 isClient = true;
	 peerName = args[0];
	 peerPort = Integer.valueOf(args[1]).intValue();
	 peerLocation = new Location (Location.INTERNET_TYPE,
	    peerName+":"+peerPort, "");
	 System.out.println ("We are the client.  Location of server is " + 
	    peerLocation.toString());
      }

      doYourStuff();
   }

   // Main guts of the test program
   private void doYourStuff() {
      SignalConnection sc = null;
      if ( isClient ) { // call up the server
	 System.out.println ("Client is calling the server...");
	 try { sc = myDS.Dial(peerLocation, (Channel)null, null ); }
	 catch ( Exception e ) { System.out.println ("Could not start the " +
	 " dial because " + e ); }
	 System.out.print   ("We received a SignalConnection: " );
	 System.out.println ( sc == null ? "false" : "true" ); 
         finish();
      }
      else { // we are the server - wait for a call
	 Thread t = new ThreadWait ( this );
	 t.start();
      }
   }

   // Terminate the test
   private void finish() {
      System.out.println ("Logging out from DesktopSignaling");
      myDS.logout();
      System.out.println ("Successful termination of Little test");
      System.exit(0);
   }

   // Here are the methods that over-ride the null AbstractSignalingObserver

   // We have received an invitation from our peer
   public void onInvite ( InviteSignalEvent ise ) {
      Connection c = null;
      System.out.println ("We have received something.");
      try {c = new AudioConnection ( (Channel) null, null );}
      catch (Exception e) { 
	 System.out.println ("Could not open a dummy channel because " + e);
      }
      ise.accept(c);
   }

   // We have received a hangup request from our peer
   public void onHangup ( HangupSignalEvent hse ) {
      finish();
   }

   public static void main (String[] args) {
      Little me = new Little( args );
   }

   // server thread loops until you press enter
   private class ThreadWait extends Thread {

      private Little me = null;
      private ThreadWait ( Little me_ ) { me = me_; }

      public void run() {
	 int r;
	 System.out.println (
	 "\n==================================================");
	 System.out.println ( "Press Enter to halt this Little server");
	 System.out.println (
	 "==================================================\n");
	 try { System.in.read (); }
	 catch ( IOException e ) {}
	 try {Thread.sleep(2000);} // sleep for 2 seconds
	 catch (InterruptedException e){}
	 me.finish();

      }
   }  // ends ThreadWait
}
